//------------------------------------------------------------------------------
// File: svr_cmdcomponent.cs
// This file contains the server methods and data for the command component
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! BuildCmdData
//! Datablock for the build command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(BuildCmdData)
{
   // Button commands
   btnSelect = "csExecuteBldgHudCmdBtn();";
   // Button image
	btnIconEnabled = "assets/client/ui/icons/build.png";
	btnIconDisabled = "assets/client/ui/icons/build.png";
	btnIconOffset ="-3 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! DemolishCmdData
//! Datablock for the demolish command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(DemolishCmdData)
{
   // Button commands
   btnSelect = "csExecuteDemolishCmdBtn();";
   btnRequire = "csReqBridgeDestroy();";
   
   // Button Image
	btnIconEnabled = "assets/client/ui/icons/demolish.png";
	btnIconDisabled = "assets/client/ui/icons/demolish.png";
	btnIconOffset ="7 7";
	btnDisableImage = "assets/client/ui/hud/demolishbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitMaleSlingerCmdData
//! Datablock for the male gunslinger recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitMaleSlingerCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteRecruitSlingerCmdBtn(RecruitMaleSlingerCmdData, Malegunslinger);";
   btnUpdate  = "csUpdateRecruitSlingerCmdBtn(RecruitMaleSlingerCmdData);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/malegunslinger.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	btnRequire = "csReqHasEmployee();";
	
	btnSelector = "slinger";
	
	// Button cost
	goldCost = 100;
	chance = 42;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitFemaleSlingerCmdData
//! Datablock for the female gunslinger recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitFemaleSlingerCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteRecruitSlingerCmdBtn(RecruitFemaleSlingerCmdData, Femalegunslinger);";
   btnUpdate  = "csUpdateRecruitSlingerCmdBtn(RecruitFemaleSlingerCmdData);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/femalegunslinger.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	btnRequire = "csReqHasEmployee();";
	
	btnSelector = "slinger";
	
	// Button cost
	goldCost = 100;
	chance = 42;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitToughSlingerCmdData
//! Datablock for the tough gunslinger recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitToughSlingerCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteRecruitSlingerCmdBtn(RecruitToughSlingerCmdData, Toughgunslinger);";
   btnUpdate  = "csUpdateRecruitSlingerCmdBtn(RecruitToughSlingerCmdData);";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/toughgunslinger.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	btnRequire = "csReqHasEmployee();";
	
	btnSelector = "slinger";
	
	// Button cost
	goldCost = 150;
	chance = 8;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitWeakSlingerCmdData
//! Datablock for the tough gunslinger recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitWeakSlingerCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteRecruitSlingerCmdBtn(RecruitWeakSlingerCmdData, Nicegunslinger);";
   btnUpdate  = "csUpdateRecruitSlingerCmdBtn(RecruitWeakSlingerCmdData);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/nicegunslinger.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	btnRequire = "csReqHasEmployee();";
	
	btnSelector = "slinger";
	
	// Button cost
	goldCost = 130;
	chance = 8;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitDeputyCmdData
//! Datablock for the deputy recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitDeputyCmdData)
{
   // Button callbacks
   btnRequire = "csIsRecruitDeputyCmdBtnEnabled();";
   btnSelect  = "csExecuteRecruitDeputyCmdBtn(RecruitDeputyCmdData, Deputy);";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/deputy.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	
	btnSelector = "deputy";
	
	// Button cost
	goldCost = 120;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitToughSheriffCmdData
//! Datablock for the tough sheriff recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitToughSheriffCmdData)
{
   // Button callbacks
   btnRequire = "csIsRecruitSheriffCmdBtnEnabled(RecruitToughSheriffCmdData);";
   btnSelect  = "csExecuteRecruitSheriffCmdBtn(RecruitToughSheriffCmdData, Toughsheriff);";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/toughsheriff.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="13 5";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	
	btnSelector = "toughsheriff";

	// Button cost
	goldCost = 200;
};

////////////////////////////////////////////////////////////////////////////////
//! RecruitWeakSheriffCmdData
//! Datablock for the weak sheriff recruit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RecruitWeakSheriffCmdData)
{
   // Button callbacks
   btnRequire = "csIsRecruitSheriffCmdBtnEnabled(RecruitWeakSheriffCmdData);";
   btnSelect = "csExecuteRecruitSheriffCmdBtn(RecruitWeakSheriffCmdData, Nicesheriff);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/nicesheriff.png";
   btnIconDisabled = "assets/client/ui/icons/dot.png";
	btnIconOffset ="15 10";
	btnDisableImage = "assets/client/ui/hud/hiredisable.png";
	
	btnSelector = "weaksheriff";

	// Button cost
	goldCost = 200;
};

// ACTION COMMANDS

////////////////////////////////////////////////////////////////////////////////
//! QuitJobCmdData
//! Datablock for the quit job command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(QuitJobCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteQuitJobCmdBtn();";
   btnRequire = "csReqEmploy(true);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/quitjob.png";
   btnIconDisabled = "assets/client/ui/icons/quitjob.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! GetJobCmdData
//! Datablock for the get job command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(GetJobCmdData)
{
   // Button commands
   btnSelect  = "csCmdOnButton($CSC_EMPLOY);";
   btnRequire = "csReqEmploy(false);";
   btnRequire = "csReqNotProtestHome();";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/jobicon.png";
   btnIconDisabled = "assets/client/ui/icons/jobicon.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! GetJobCmdData
//! Datablock for the get job command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(RepairCmdData)
{
  // Button commands
   btnSelect  = "csCmdOnButton($CSC_REPAIR);";

  // Button images
   btnIconEnabled = "assets/client/ui/icons/repair.png";
   btnIconDisabled = "assets/client/ui/icons/repair.png";
   btnIconOffset ="-3 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! AttackCmdData
//! Datablock for the attack command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(AttackCmdData)
{
   // Button commands
   btnSelect  = "csCmdOnButton($CSC_ATTACK);";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/attack.png";
   btnIconDisabled = "assets/client/ui/icons/attack.png";
	btnIconOffset ="-3 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! DismissCmdData
//! Datablock for the dismiss hired unit command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(DismissCmdData)
{  
   // Button commands
   btnSelect = "csExecuteDismissCmdBtn();";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/quitjob.png";
   btnIconDisabled = "assets/client/ui/icons/quitjob.png";
	btnIconOffset ="-2 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! OutpostUpgradeCmdData
//! Datablock for the outpost upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(OutpostUpgradeCmdData)
{
   // Button commands
   btnSelect = "csExecuteBldgUpgradeCmdBtn(OutpostUpgradeCmdData, Outpost);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/outpost.png";
   btnIconDisabled = "assets/client/ui/icons/outpost.png";
	btnIconOffset ="-3 2";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	
   // Resources
   goldCost = 140;
   woodCost = 140;
};

////////////////////////////////////////////////////////////////////////////////
//! BldgUpgradeCmdData
//! Datablock for the train station upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(TrainStationUpgradeCmdData)
{
   // Button commands
   btnSelect = "csExecuteBldgUpgradeCmdBtn(TrainStationUpgradeCmdData, TrainStation);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/trainstation.png";
   btnIconDisabled = "assets/client/ui/icons/trainstation.png";
	btnIconOffset ="0 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	
	// Resources
   goldCost = 200;
   woodCost = 200;
};

////////////////////////////////////////////////////////////////////////////////
//! TrackUpgradeCmdData
//! Datablock for the track upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(TrackUpgradeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteUpgradeCmdBtn(TrackUpgradeCmdData, $CSUP_TRACK, 1.25);";
   btnRequire = "csReqUpgradeAvail($CSUP_TRACK);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/train.png";
   btnIconDisabled = "assets/client/ui/icons/train.png";
	btnIconOffset = "-3 0";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	
	btnSelector = "trackupgrade";
};

////////////////////////////////////////////////////////////////////////////////
//! PickUpgradeCmdData
//! Datablock for the pick axe upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(PickUpgradeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteUpgradeCmdBtn(PickUpgradeCmdData, $CSUP_PICK, 1.25);";
   btnRequire = "csReqUpgradeAvail($CSUP_PICK);";
   btnRequire = "csReqHasEmployee();";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/pickaxeupgrade.png";
   btnIconDisabled = "assets/client/ui/icons/pickaxeupgradedisable.png";
	btnIconOffset = "1 1";
	btnDisableImage = "assets/client/ui/hud/blacksmithupgradedisable.png";
	
	btnSelector = "pickupgrade";
};

////////////////////////////////////////////////////////////////////////////////
//! AxeUpgradeCmdData
//! Datablock for the lumber axe upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(AxeUpgradeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteUpgradeCmdBtn(AxeUpgradeCmdData, $CSUP_AXE, 1.25);";
   btnRequire = "csReqUpgradeAvail($CSUP_AXE);";
   btnRequire = "csReqHasEmployee();";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/axeupgrade.png";
   btnIconDisabled = "assets/client/ui/icons/axeupgradedisable.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/blacksmithupgradedisable.png";   
	
	btnSelector = "axeupgrade";
};

////////////////////////////////////////////////////////////////////////////////
//! GunUpgradeCmdData
//! Datablock for the gun upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(GunUpgradeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteUpgradeCmdBtn(GunUpgradeCmdData, $CSUP_GUN, 1.1 SPC 1.2);";
   btnRequire = "csReqUpgradeAvail($CSUP_GUN);";
   btnRequire = "csReqHasEmployee();";

   // Button images
   btnIconEnabled = "assets/client/ui/icons/gunupgrade.png";
   btnIconDisabled = "assets/client/ui/icons/gunupgradedisable.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/blacksmithupgradedisable.png";
	
	btnSelector = "gunupgrade";
};

////////////////////////////////////////////////////////////////////////////////
//! BldgHpUpgradeCmdData
//! Datablock for the building hp upgrade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(BldgHpUpgradeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteUpgradeCmdBtn(BldgHpUpgradeCmdData, $CSUP_BLDG, 10);";
   btnRequire = "csReqUpgradeAvail($CSUP_BLDG);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/strongerbuilding.png";
   btnIconDisabled = "assets/client/ui/icons/strongerbuilding.png";
	btnIconOffset ="-3 -2";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	btnRequire = "csReqHasEmployee();";
	
	btnSelector = "bldgupgrade";
};

////////////////////////////////////////////////////////////////////////////////
//! NoTaxCmdData
//! Datablock for the no tax command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(NoTaxCmdData)
{
   // Button commands
   btnSelect  = "csExecuteProductionSwapCmdBtn(notax, NoTaxCmdData);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqNoTimer(NoTaxCmdData);";
   btnUpdate  = "csUpdateBmpTimer(NoTaxCmdData);";
   
   // Button selection indicator
   btnSelector = "notax";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/taxnone.png";
   btnIconDisabled = "assets/client/ui/icons/taxnone.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! LowTaxCmdData
//! Datablock for the low tax command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(LowTaxCmdData)
{
   // Button commands
   btnSelect  = "csExecuteProductionSwapCmdBtn(lowtax, LowTaxCmdData);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqBldgExists(Bank, 1);";
   btnRequire = "csReqNoTimer(LowTaxCmdData);";
   btnUpdate  = "csUpdateBmpTimer(LowTaxCmdData);";
   
   // Button selection indicator
   btnSelector = "lowtax";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/taxlow.png";
   btnIconDisabled = "assets/client/ui/icons/taxlow.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
   
};

////////////////////////////////////////////////////////////////////////////////
//! HighTaxCmdData
//! Datablock for the high tax command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(HighTaxCmdData)
{
   // Button commands
   btnSelect  = "csExecuteProductionSwapCmdBtn(hightax, HighTaxCmdData);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqBldgExists(Bank, 2);";
   btnRequire = "csReqNoTimer(HighTaxCmdData);";
   btnUpdate  = "csUpdateBmpTimer(HighTaxCmdData);";
   
   // Button selection indicator
   btnSelector = "hightax";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/taxhigh.png";
   btnIconDisabled = "assets/client/ui/icons/taxhigh.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ParadeCmdData
//! Datablock for the parade command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ParadeCmdData)
{
   // Button commands
   btnSelect  = "csExecuteParadeCmdBtn(ParadeCmdData);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqNoTimer(ParadeCmdData);";
   btnUpdate  = "csUpdateParadeBmpTimer(ParadeCmdData);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/parade.png";
   btnIconDisabled = "assets/client/ui/icons/parade.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	
	// Cost for purchase
   goldCost = 40;
   woodCost = 20;
	
	// parade happiness modifiers
	happinessCount = 25;
   happinessIncrease = 0;
   happinessPlateau = 60;
   happinessDecrease = 0;
};

// CROPS AND LIVESTOCKS

////////////////////////////////////////////////////////////////////////////////
//! ProduceWheatCmdData
//! Datablock for the produce wheat command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceWheatCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(wheat, ProduceWheatCmdData);";
   btnRequire = "csReqNoTimer(ProduceWheatCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProduceWheatCmdData);";
   btnRequire = "csReqHasEmployee();";
   
    // Button selection indicator
   btnSelector = "wheat";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/wheat.png";
   btnIconDisabled = "assets/client/ui/icons/wheat.png";
	btnIconOffset ="-4 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceCornCmdData
//! Datablock for the produce corn command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceCornCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(corn, ProduceCornCmdData);";
   btnRequire = "csReqNoTimer(ProduceCornCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProduceCornCmdData);";
   btnRequire = "csReqHasEmployee();";
    // Button selection indicator
   btnSelector = "corn";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/corn.png";
   btnIconDisabled = "assets/client/ui/icons/corn.png";
	btnIconOffset ="-4 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProducePumpCmdData
//! Datablock for the produce pumpkin command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProducePumpCmdData)
{
    // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(pumpkin, ProducePumpCmdData);";
   btnRequire = "csReqNoTimer(ProducePumpCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProducePumpCmdData);";
   btnRequire = "csReqHasEmployee();";
    // Button selection indicator
   btnSelector = "pumpkin";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/pumpkin.png";
   btnIconDisabled = "assets/client/ui/icons/pumpkin.png";
	btnIconOffset ="-4 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceChickenCmdData
//! Datablock for the produce pig command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceChickenCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(chicken, ProduceChickenCmdData);";
   btnRequire = "csReqNoTimer(ProduceChickenCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProduceChickenCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button selection indicator
   btnSelector = "chicken";
   
	// Button images
   btnIconEnabled = "assets/client/ui/icons/chicken.png";
   btnIconDisabled = "assets/client/ui/icons/chicken.png";
	btnIconOffset ="-4 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";

};

////////////////////////////////////////////////////////////////////////////////
//! ProducePigCmdData
//! Datablock for the produce pig command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProducePigCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(pig, ProducePigCmdData);";
   btnRequire = "csReqNoTimer(ProducePigCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProducePigCmdData);";
    btnRequire = "csReqHasEmployee();";
   // Button selection indicator
   btnSelector = "pig";
   
	// Button images
   btnIconEnabled = "assets/client/ui/icons/pig.png";
   btnIconDisabled = "assets/client/ui/icons/pig.png";
	btnIconOffset ="-4 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceCowCmdData
//! Datablock for the produce cow command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceCowCmdData)
{
    // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(cow, ProduceCowCmdData);";
   btnRequire = "csReqNoTimer(ProduceCowCmdData);";
	btnUpdate  = "csUpdateBmpTimer(ProduceCowCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button selection indicator
   btnSelector = "cow";
   
	// Button images
   btnIconEnabled = "assets/client/ui/icons/cattle.png";
   btnIconDisabled = "assets/client/ui/icons/cattle.png";
	btnIconOffset ="-2 -1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceSheepCmdData
//! Datablock for the produce sheep command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceSheepCmdData)
{
   // Button callbactsks
   btnSelect  = "csExecuteProductionSwapCmdBtn(sheep, ProduceSheepCmdData);";
   btnRequire = "csReqNoTimer(ProduceSheepCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProduceSheepCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button selection indicator
   btnSelector = "sheep";
   
	// Button images
   btnIconEnabled = "assets/client/ui/icons/sheep.png"; 
   btnIconDisabled = "assets/client/ui/icons/sheep.png";
	btnIconOffset ="1 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
	
	btnDisabledInvisible = true;
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceGoldCmdData
//! Datablock for the produce gold command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceGoldCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteProductionSwapCmdBtn(gold, ProduceGoldCmdData);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqNoTimer(ProduceGoldCmdData);";
   btnUpdate  = "csUpdateBmpTimer(ProduceGoldCmdData);";

   // Button selection indicator
   btnSelector = "gold";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/gold.png";
   btnIconDisabled = "assets/client/ui/icons/gold.png";
	btnIconOffset ="-3 0";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceWoodCmdData
//! Datablock for the produce wood command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceWoodCmdData)
{
  // Button callbacks
  btnSelect  = "csExecuteProductionSwapCmdBtn(wood, ProduceWoodCmdData);";
  btnRequire = "csReqHasEmployee();";
  btnRequire = "csReqNoTimer(ProduceWoodCmdData);";
  btnUpdate  = "csUpdateBmpTimer(ProduceWoodCmdData);";

  // Button selection indicator
  btnSelector = "wood";

  // Button images
  btnIconEnabled = "assets/client/ui/icons/wood.png";
  btnIconDisabled = "assets/client/ui/icons/wood.png";
  btnIconOffset ="-5 0";
  btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

////////////////////////////////////////////////////////////////////////////////
//! ProduceFoodCmdData
//! Datablock for the produce food command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(ProduceFoodCmdData)
{
  // Button callbacks
  btnSelect  = "csExecuteProductionSwapCmdBtn(food, ProduceFoodCmdData);";
  btnRequire = "csReqHasEmployee();";
  btnRequire = "csReqNoTimer(ProduceFoodCmdData);";
  btnUpdate  = "csUpdateBmpTimer(ProduceFoodCmdData);";

  // Button selection indicator
  btnSelector = "food";

  // Button images
  btnIconEnabled = "assets/client/ui/icons/food.png";
  btnIconDisabled = "assets/client/ui/icons/food.png";
	btnIconOffset ="-3 1";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
};

// TOOLS

////////////////////////////////////////////////////////////////////////////////
//! PurchaseDynamiteCmdData
//! Datablock for the purchase dynamite command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(PurchaseDynamiteCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteItemPurchaseCmdBtn(PurchaseDynamiteCmdData, $INV_DYNAMITE);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqCanPushItem($INV_DYNAMITE);";
   
	// Button images
	btnDisableImage = "assets/client/ui/hud/soldout.png";
   // Cost for purchase
   goldCost = 100;
};

////////////////////////////////////////////////////////////////////////////////
//! PurchaseHealCmdData
//! Datablock for the purchase healing command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(PurchaseHealCmdData)
{
   // Button callbacks
   btnSelect  = "csExecuteItemPurchaseCmdBtn(PurchaseHealCmdData, $INV_HEALING);";
   btnRequire = "csReqHasEmployee();";
   btnRequire = "csReqCanPushItem($INV_HEALING);";
	
	// Button images
	btnDisableImage = "assets/client/ui/hud/soldout.png";
   // Cost for purchase
   goldCost = 40;
};

////////////////////////////////////////////////////////////////////////////////
//! UseDynamiteCmdData
//! Datablock for the use dynamite command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(UseDynamiteCmdData)
{
  // Button commands
  btnSelect  = "csExecuteItemUseCmdBtn($INV_DYNAMITE);";
  btnRequire = "csReqToolAvailable($INV_DYNAMITE);";
  btnRequire = "csReqNoBuild();";
  btnUpdate  = "csUpdateToolText(CharCmdBtnText5, $INV_DYNAMITE);";

  // Button images
   btnIconEnabled = "assets/client/ui/icons/dynamitesm.png";
   btnIconDisabled = "assets/client/ui/icons/dynamiteempty.png";
   btnIconOffset = "-1 0";
	btnDisableImage = "assets/client/ui/hud/buildingbutton.png";
};

////////////////////////////////////////////////////////////////////////////////
//! UseHealingCmdData
//! Datablock for the use healing command button
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(UseHealingCmdData)
{
   // Button commands
   btnSelect  = "csExecuteItemUseCmdBtn($INV_HEALING);";
   btnRequire = "csReqToolAvailable($INV_HEALING);";
   btnUpdate  = "csUpdateToolText(CharCmdBtnText6, $INV_HEALING);";
   
   // Button images
   btnIconEnabled = "assets/client/ui/icons/healthkitsm.png";
   btnIconDisabled = "assets/client/ui/icons/healthkitempty.png";
	btnIconOffset ="-1 0";
	btnDisableImage = "assets/client/ui/hud/buildingbutton.png";
};


////////////////////////////////////////////////////////////////////////////////
//! GoldForFoodCmdData
//! Datablcok for the trade gold for food command button (Note Alex: use this
//! as a template for trading post buttons)
////////////////////////////////////////////////////////////////////////////////
datablock CommandData(GoldForFoodCmdData)
{
   // sell food
   btnSelect  = "csExecuteResourceTradeCmdBtn(GoldForFoodCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button images
   btnIconEnabled = "assets/client/ui/icons/sellfood.png";
   btnIconDisabled = "assets/client/ui/icons/sellfood.png";
	btnIconOffset ="8 4";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
   
   // Resources
   foodCost = 20;
   goldGain = 10;
};
datablock CommandData(GoldForWoodCmdData)
{
   // Sell wood
   btnSelect  = "csExecuteResourceTradeCmdBtn(GoldForWoodCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button images
   btnIconEnabled = "assets/client/ui/icons/sellwood.png";
   btnIconDisabled = "assets/client/ui/icons/sellwood.png";
	btnIconOffset ="7 4";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
   
   // Resources
   woodCost = 20;
   goldGain = 10;
};
datablock CommandData(WoodForGoldCmdData)
{
   // Buy Wood
   btnSelect  = "csExecuteResourceTradeCmdBtn(WoodForGoldCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button images
   btnIconEnabled = "assets/client/ui/icons/buywood.png";
   btnIconDisabled = "assets/client/ui/icons/buywood.png";
	btnIconOffset ="8 4";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
   
   // Resources
   goldCost = 20;
   woodGain = 10;
};
datablock CommandData(FoodForGoldCmdData)
{
   // Buy Food
   btnSelect  = "csExecuteResourceTradeCmdBtn(FoodForGoldCmdData);";
   btnRequire = "csReqHasEmployee();";
   // Button images
   btnIconEnabled = "assets/client/ui/icons/buyfood.png";
   btnIconDisabled = "assets/client/ui/icons/buyfood.png";
	btnIconOffset ="7 4";
	btnDisableImage = "assets/client/ui/hud/buildbtndisable.png";
   
   // Resources
   goldCost = 25;
   foodGain = 10;
};
datablock CommandData(TradepanelCmdData)
{
   // Button images
   stateUp = "assets/client/ui/hud/tradingpostpanel.jpg";
   btnDisableImage = "assets/client/ui/hud/tradingpostpanel.jpg";
};
datablock CommandData(PumpkinpieCmdData)
{
   // Button images
   stateUp = "assets/client/ui/icons/pumpkinpie.jpg";
   btnDisableImage = "assets/client/ui/icons/storeempty.jpg";
};
datablock CommandData(honeyjarCmdData)
{
   // Button images
   stateUp = "assets/client/ui/icons/honeyjar.jpg";
   btnDisableImage = "assets/client/ui/icons/storeempty.jpg";
};

datablock CommandData(woolCmdData)
{
   // Button images
   stateUp = "assets/client/ui/icons/wool.jpg";
   btnDisableImage = "assets/client/ui/icons/storeempty.jpg";
};

////////////////////////////////////////////////////////////////////////////////
//! Town Unit
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(CivilianCmdData)
{
   addCommand = "BuildCmdData 0 1";
   addCommand = "RepairCmdData 1 1";
   addCommand = "GetJobCmdData 2 1";
   addCommand = "QuitJobCmdData 3 0";
   addCommand = "UseDynamiteCmdData 5 0";
};

////////////////////////////////////////////////////////////////////////////////
//! Hero Unit
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(HeroCmdData)
{
   addCommand = "BuildCmdData 0 1";
   addCommand = "RepairCmdData 1 1";
   addCommand = "AttackCmdData 4 1";
   addCommand = "UseDynamiteCmdData 5 0";
   addCommand = "UseHealingCmdData 6 0";
};

////////////////////////////////////////////////////////////////////////////////
//! Combat Unit
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(CombatCmdData)
{
   addCommand = "AttackCmdData 4 1";
   //addCommand = "UseDynamiteCmdData 5 0";
   addCommand = "UseHealingCmdData 6 0";
};

// BUILDINGS

////////////////////////////////////////////////////////////////////////////////
//! Saloon
//! Command component datablock for the saloon game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(SaloonCmdData)
{
   addCommand = "RecruitMaleSlingerCmdData 6";
   pushCommand = "RecruitFemaleSlingerCmdData";
   pushCommand = "RecruitToughSlingerCmdData";
   pushCommand = "RecruitWeakSlingerCmdData";
   addCommand = "RecruitMaleSlingerCmdData 7";
   pushCommand = "RecruitFemaleSlingerCmdData";
   pushCommand = "RecruitToughSlingerCmdData";
   pushCommand = "RecruitWeakSlingerCmdData";
   addCommand = "RecruitMaleSlingerCmdData 8";
   pushCommand = "RecruitFemaleSlingerCmdData";
   pushCommand = "RecruitToughSlingerCmdData";
   pushCommand = "RecruitWeakSlingerCmdData";
   addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! Farm
//! Command component datablock for the farm game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(FarmCmdData)
{
   addCommand = "ProduceWheatCmdData 12";
   addCommand = "ProduceCornCmdData 13";
   addCommand = "ProducePumpCmdData 14";
   addCommand = "DemolishCmdData 5";
};
////////////////////////////////////////////////////////////////////////////////
//! Ranch
//! Command component datablock for the ranch game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(RanchCmdData)
{
   addCommand = "ProduceChickenCmdData 15";
   addCommand = "ProducePigCmdData 16";
   addCommand = "ProduceCowCmdData 17";
   addCommand = "ProduceSheepCmdData 11";  
   addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! General Store
//! Command component datablock for the general store game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(GeneralCmdData)
{
   addCommand = "PurchaseDynamiteCmdData 10";
   addCommand = "PurchaseHealCmdData 9";
   addCommand = "PumpkinpieCmdData 22";
   addCommand = "honeyjarCmdData 23";
   addCommand = "woolCmdData 24";
   addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! Sheriff's Office
//! Command component datablock for the SheriffsOffice game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(SheriffsOfficeCmpData)
{
   addCommand = "RecruitToughSheriffCmdData 31";
   addCommand = "RecruitWeakSheriffCmdData 32";
   addCommand = "RecruitDeputyCmdData 29";
	addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! Town Hall
//! Command component datablock for the Town hall game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(TownhallCmdData)
{
   addCommand = "NoTaxCmdData 0";
   addCommand = "LowTaxCmdData 1";
   addCommand = "HighTaxCmdData 2";
   addCommand = "ParadeCmdData 3";
	addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! Platform
//! Command component datablock for the Platform game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(PlatformCmdData)
{
   addCommand = "OutpostUpgradeCmdData 36";
};

////////////////////////////////////////////////////////////////////////////////
//! Outpost
//! Command component datablock for the Outpost game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(OutpostCmdData)
{
   addCommand = "ProduceGoldCmdData 33";
   addCommand = "ProduceWoodCmdData 40";
   addCommand = "ProduceFoodCmdData 35";
   addCommand = "TrainStationUpgradeCmdData 37";
   //addCommand = "PlatformUpgradeCmdData 4";
};

////////////////////////////////////////////////////////////////////////////////
//! Train Station
//! Command component datablock for the Train Station game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(TrainStationCmdData)
{
   addCommand = "ProduceGoldCmdData 33";
   addCommand = "ProduceWoodCmdData 40";
   addCommand = "ProduceFoodCmdData 35"; 
   addCommand = "TrackUpgradeCmdData 38";
   //addCommand = "PlatformUpgradeCmdData 4";
};

////////////////////////////////////////////////////////////////////////////////
//! Blacksmith
//! Command component datablock for the Blacksmith game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(BlacksmithCmdData)
{
   addCommand = "PickUpgradeCmdData 25";
   addCommand = "AxeUpgradeCmdData 26";
   addCommand = "GunUpgradeCmdData 27";
   addCommand = "DemolishCmdData 5";
};

////////////////////////////////////////////////////////////////////////////////
//! Trading Post
//! Command component datablock for the game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(TradingpostCmdData)
{
   addCommand = "FoodForGoldCmdData 19"; //buy food
   addCommand = "GoldForWoodCmdData 21"; //sell wood
   addCommand = "GoldForFoodCmdData 20"; //sell food
   addCommand = "WoodForGoldCmdData 18"; //buy wood
   addCommand = "TradepanelCmdData 4"; //background panel for trading post
   addCommand = "DemolishCmdData 5";
};
////////////////////////////////////////////////////////////////////////////////
//! Lumber Mill
//! Command component datablock for the game object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(LumbermillCmdData)
{
   addCommand = "BldgHpUpgradeCmdData 28";
   addCommand = "DemolishCmdData 5";
};
////////////////////////////////////////////////////////////////////////////////
//! Base Demolish
//! Command component datablock for the Bridge link object
////////////////////////////////////////////////////////////////////////////////
datablock CCmpCommandData(BaseCmdData)
{
   addCommand = "DemolishCmdData 5";
};

//-CommandData Methods----------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////
//! Checks if the current command can be purchased with current resources
////////////////////////////////////////////////////////////////////////////////
function CommandData::canPurchaseCommand(%this)
{
   // Check each resource
   if(%this.goldCost > rsGetResourceCount($Resource::Gold)) {
      return false;
   }
   if(%this.woodCost > rsGetResourceCount($Resource::Wood)) {
      return false;
   }
   if(%this.foodCost > rsGetResourceCount($Resource::Food)) {
      return false;
   }
   if(%this.waterCost > rsGetResourceCount($Resource::Water)) {
      return false;
   }
   if(%this.expCost > rsGetResourceCount($Resource::Experience)) {
      return false;
   }
   
   // Can be purchased
   return true;
}

////////////////////////////////////////////////////////////////////////////////
//! "Purchases" commands by deducting resources and adding resources
////////////////////////////////////////////////////////////////////////////////
function CommandData::purchaseCommand(%this)
{
   %resource = GameResourceStack.getResource();
   %resource.clearHappinessRates();
   
   // Deduct each resource for cost
   if(%this.goldCost > 0) {
      rsGetResource($Resource::Gold).decreaseCount(%this.goldCost);
   }
   if(%this.woodCost > 0) {
      rsGetResource($Resource::Wood).decreaseCount(%this.woodCost);
   }
   if(%this.foodCost > 0) {
      rsGetResource($Resource::Food).decreaseCount(%this.foodCost);
   }
   if(%this.waterCost > 0) {
      rsGetResource($Resource::Water).decreaseCount(%this.waterCost);
   }
   if(%this.expCost > 0) {
      rsGetResource($Resource::Experience).decreaseCount(%this.expCost);
   }
   
   // Resource gain if any
   if(%this.goldGain > 0) {
      rsGetResource($Resource::Gold).increaseCount(%this.goldGain);
   }
   if(%this.woodGain > 0) {
      rsGetResource($Resource::Wood).increaseCount(%this.woodGain);
   }
   if(%this.foodGain > 0) {
      rsGetResource($Resource::Food).increaseCount(%this.foodGain);
   }
   if(%this.waterGain > 0) {
      rsGetResource($Resource::Water).increaseCount(%this.waterGain);
   }
   if(%this.expGain > 0) {
      rsGetResource($Resource::Experience).increaseCount(%this.expGain);
   }
}

//------------------------------------------------------------------------------

// this function is called form the client when the command component
// is initialized with a use list
function serverCmdSaveUseList(%client, %ghostID, %data)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostID);
   %object.useList = %data;
}

// this function is called when an id in the use list needs to be
// updated (one of the indices change)
function serverCmdUpdateUseList(%client, %ghostID, %index, %data)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostID);

   %newData = "";
   %count = getWordCount(%object.useList);
   for (%newIndex = 0; %newIndex < %count; %newIndex++)
   {
      if (%newIndex == %index)
      {
         %newData = %newData @ %data @ " ";
      }
      else
      {
         %newData = %newData @ getWord(%object.useList, %newIndex) @ " ";
      }
   }
   
   %object.useList = %newData;
}

// this function is called when the command component is loaded from
// a saved file-- tells the client what the use list should be
function CCmpCommand::LoadUseList(%component)
{
   %client = ClientGroup.getObject(0);
   %ghostID = %client.getGhostId(%component);
   commandToClient(%client, 'LoadUseList', %ghostID, %component.useList);
}


// End svr_cmdcomponent.cs
